# Rephrase and Respond: Let Large Language Models Ask Better Questions for Themselves

**Authors:** Yihe Deng, Weitong Zhang, Zixiang Chen, Quanquan Gu
**Institution:** Department of Computer Science, University of California Los Angeles

## Abstract

Misunderstandings arise not only in interpersonal communication but also between humans and Large Language Models (LLMs). Such discrepancies can make LLMs interpret seemingly unambiguous questions in unexpected ways, yielding incorrect responses. While it is widely acknowledged that the quality of a prompt, such as a question, significantly impacts the quality of the response provided by LLMs, a systematic method for crafting questions that LLMs can better comprehend is still underdeveloped. In this paper, we present a method named 'Rephrase and Respond' (RaR), which allows LLMs to rephrase and expand questions posed by humans and provide responses in a single prompt. This approach serves as a simple yet effective prompting method for improving performance. We also introduce a two-step variant of RaR, where a rephrasing LLM first rephrases the question and then passes the original and rephrased questions together to a different responding LLM. This facilitates the effective utilization of rephrased questions generated by one LLM with another. Our experiments demonstrate that our methods significantly improve the performance of different models across a wide range to tasks. We further provide a comprehensive discussion with the popular Chain-of-Thought (CoT) methods. We show that RaR is complementary to CoT and can be combined with CoT to achieve even better performance. Our work not only contributes to enhancing LLM performance efficiently and effectively but also sheds light on a fair evaluation of LLM capabilities.

## Introduction

Large Language Models (LLMs), such as the GPT series [radford2019language; brown2020language; openai2023gpt4], have witnessed a surge in popularity due to their profound impact on various real-world applications, including question answering [lu2023mathvista], code generation [poesia2022synchromesh], and conversational agents [bozkurt2023generative]. The wide applicability and efficacy of these models have led to rapidly growing research on understanding and improving the use of LLMs. Meanwhile, it is widely acknowledged that the quality of the prompt generated by humans critically influences the response quality of the LLMs, emphasizing the importance of effective queries that prioritize specificity, detail, and precision [practice_for_prompt]. The sensitivity to prompt qualities, on the other hand, limits the usage of LLMs to their full potential and requires a systematic way to improve human's prompt.

Misunderstandings in interpersonal communications often arise when individuals, shaped by distinct subjective experiences, interpret the same message differently. In social science, such phenomena can be attributed to cognitive biases in frames in thought [druckman2001implications]. A single message, framed in different ways, can lead individuals to different conclusions. People habitually project their frames onto their received information, and only shift these frames when incongruence arises. In this work, we posit that LLMs also exhibit their own frames in thought, and it is not uncommon to observe a disparity between the frames used by humans and LLMs that caused the LLM's sensitivity to prompt qualities. Meanwhile, it can be challenging for humans to assess the clarity of their questions and to align their frames with those of LLMs. To illustrate this, we first present a motivating example by investigating a recent work [allenzhu2023physics] in detail.

[IMAGE: Motivating examples of our study. We can observe several ambiguities in the question for LLMs. An LLM can interpret "even month" as the month with an even number of days, which diverges from human intention.]

### Motivating Example

[allenzhu2023physics] found that LLMs such as GPT-4 may not efficiently reason with their internal knowledge even if they can retrieve information accurately. When posed with the query, "Was Mother Teresa born on an even month?" GPT-4 might mistakenly assert that August is an odd month. Based on this observation, [allenzhu2023physics] suggested that GPT-4 instead requires a Chain-of-Thought process -- relying on user-led follow-up questions -- to correct its previous wrong answers. However, we take a step further to investigate the intrinsic reason for LLM's inefficiency in answering such questions. When GPT-4 explains its reasoning, the model has several ambiguities toward the questions. For example, it may consider February as odd due to its irregular number of days and sometimes consider an even/odd month to be months with an even/odd number of days.

Ambiguity in questions [cole2023selectively; kim2023tree] is a recognized concern in benchmark datasets. For instance, it has been observed that the NLI datasets such as MultiNLI [williams-etal-2018-broad] contain ambiguities, which are challenging even for human interpreters [liu2023we]. Furthermore, our study uncovers that benchmark datasets commonly used for LLM evaluation [wei2022chain; srivastava2023beyond] possess ambiguities that are imperceptible to humans but challenging for language models. These ambiguities cause LLMs to provide mistaken responses to unintended queries.

[IMAGE: Comparison with the original question and one possible self-rephrased question of GPT-4. We can observe a marked improvement of accuracy in answering these rephrased questions over the query of 105 celebrities for this task.]

### Our Approach

In this paper, we highlight an often-overlooked aspect of studies in LLMs: the disparity between human and LLM thought frames. Our research illustrates that this disparity significantly impacts the performance of LLMs in the **zero-shot setting**. To tackle this problem, we propose to let the LLM rephrase the question and incorporate additional details for better answering. We observe that, as opposed to questions asked casually by human, the automatically rephrased questions tend to enhance semantic clarity and aid in resolving inherent ambiguity. This self-rephrasing technique leads to significant improvement in accuracy.

Building upon these insights, we introduce a method named **Rephrase and Respond** (RaR), which prompts the LLM to rearticulate the given question and respond in a single prompt. Our empirical results across diverse reasoning tasks show the effectiveness of the approach. Additionally, we leverage RaR to facilitate the transfer of rephrased questions from more capable LLMs to clarify ambiguities for the less advanced models. Lastly, we present thorough discussions with the Chain-of-Thought (CoT) method [kojima2022large; wei2022chain]. RaR is complementary to CoT and can be easily combined for improvement, as confirmed by our experimental results. Unlike methods that employ multiple LLMs for iterative prompt engineering based on accuracy scores [zhou2022large; pryzant2023automatic], our method is both **unsupervised** and **training-free**, making it economical and applicable to all questions in the zero-shot setting. Lastly, our work calls forth the importance that the design of human-crafted tasks targeting specific LLM capabilities should be rigorously reviewed by both humans and LLMs to ensure clarity in intention.

## Related Work

### Prompting Methods for LLMs

Since the advent of recent LLMs [openai2023gpt4; touvron2023llama; vicuna2023], a growing body of research has focused on prompt engineering for LLMs [brown2020language; schick2021exploiting; zhou2022large; white2023prompt; wang2023prompt]. Manual guidelines have emerged to guide users in designing and revising their prompts [Reynolds2021prompt; Saravia_Prompt_Engineering_Guide_2022]. [practice_for_prompt] has also offered general recommendations for crafting queries, emphasizing specificity, detail, and precision. However, individuals often find it challenging to refine their own questions for clarity or to include necessary details for LLMs, as the questions are clear enough for humans themselves. Subsequent research [zhou2022large; sorensen2022information; pryzant2023automatic] has concentrated on the autonomous refinement of prompts. These methods often employ multiple LLMs to generate candidate prompts, evaluate and score these prompts, and iteratively refine them until a satisfactory prompt is produced. The evaluation of a prompt typically relies on either the accuracy of an LLM's response [zhou2022large; pryzant2023automatic] or the mutual information of the question [sorensen2022information]. Given the nature of iterative computation and the necessity for qualitative evaluation, such methods are employed for refining single prompt templates; applying them universally to all questions would be expensive.

The method most frequently used by users and closely aligned with our approach is the zero-shot Chain-of-Thought (CoT) prompting [kojima2022large]. In the stronger few-shot setting, few-shot CoT [wei2022chain] has also been a strong prompting method. Given that these techniques do not require evaluation and iterative selection, they have gained widespread popularity and inspired a series of subsequent studies [wang2022self; zhou2022least; press2022measuring; yao2023tree; zhang2023multimodal; shao2023synthetic]. However, CoT methods are not without their limitations, as observed in our study. Recent investigations have also highlighted challenges with the reliability of both zero-shot CoT [turpin2023language] and few-shot CoT [pawelczyk2023incontext]. Most recently, [zhou2023far] propose Foresee and Reflect similarly as a zero-shot prompting method that targets the proposed task Thinking for Doing (T4D). Lastly, it is worth noting that our method is complementary to all the prompting techniques mentioned above and can be combined.

### Self-correction Methods for LLMs

Another line of work aims at enhancing LLM performance [madaan2023self; welleck2022generating; kim2023language; pan2023automatically; shinn2023reflexion] by leveraging the LLM to refine its own *responses*, a concept known as post-hoc prompting. This encompasses terms such as "self-correction", "self-refine", and "self-critique", where LLMs revise their own responses drawing upon various feedback sources or *critic models*. As classified by [pan2023automatically], automated critic models generally employ the LLM's self-feedback [madaan2023self; shinn2023reflexion; yan2023learning], other trained LLMs [yang2022re3; lightman2023lets], or external references [jung-etal-2022-maieutic; gao2023rarr; yu2023improving; welleck2022generating]. Yet, recent studies [huang2023large; stechly2023gpt4] examine the self-correction capacities of LLMs and find potential limitations, suggesting that LLMs may not be able to self-correct their reasoning processes. Their findings reveal that self-correction is no better than self-consistency [wang2022self]. Contrary to allowing the LLM to self-refine its responses, our method let the LLM instead rephrase questions originally crafted by humans.

**Concurrent works.** To the best of our knowledge, our work is one of the first works to examine the misunderstandings between humans and LLMs, as well as the models' ability to rephrase inputs as a means of self-improvement. Concurrently, several studies have emerged that also explore and utilize the rephrasing capabilities of LLMs. Instead of zero-shot prompting, [yu2023metamath] employs LLMs to rephrase questions for the generation of synthetic data and subsequent fine-tuning. In the domain of vision-language models, [prasad2023rephrase] similarly shows that the rephrasing ability of language models can effectively improve its own reasoning process. Furthermore, [weston2023system] introduces System 2 Attention, a method that let the LLM itself filter out irrelevant information from the original prompt and to regenerate the query.

## Aligning the Frames with Rephrase and Respond

To systematically reduce prompt ambiguity and contextualize information in a way that aligns with the existing frame of the LLMs, we propose Rephrase and Respond (RaR) as a means of self-clarification. In interpersonal communication, rephrasing is a commonly known technique where people rephrase another person's question as a process of understanding, to ensure clarity and coherence in responding. Such a communication strategy can therefore be similarly applied to an LLM, letting it generate a rephrased question first and provide an answer subsequently. Following this intuition, RaR asks the LLMs to **Rephrase** the given questions and then **Respond** within a single query. This approach can be viewed as a strategy to directly enhance the quality of the LLM's response. In detail, we introduce the following prompt for the question-answering task:

```
"{question}"\nRephrase and expand the question, and respond.
```

Our prompt design aimed for conciseness and effectiveness. Meanwhile, many other variations of the prompt remain within our methodology and also provide improvement in performance, which share the same intention of rephrasing before responding. Such prompts include but not limited to the following:

- `Reword and elaborate on the inquiry, then provide an answer.`
- `Reframe the question with additional context and detail, then provide an answer.`
- `Modify the original question for clarity and detail, then offer an answer.`
- `Restate and elaborate on the inquiry before proceeding with a response.`

In later experiments, we will show that RaR remains effective for all variations of these prompts. With rephrasing before answering, RaR offers several desirable properties including (1) letting the LLM self-improve the prompts while maintaining the context of the original query, (2) better aligning the human's intended query with LLM's preferred style of question, (3) expanding the LLM's thought process and adding a step that will not naturally appear when using CoT and (4) providing an approach for humans to interpret how LLMs understand the questions.

[IMAGE: Demonstration of RaR: one single prompt to improve LLM's response quality.]

## RaR Effectively Improves LLM Responses

In this section, we provide a comprehensive assessment of the applicability and efficacy of RaR. The results are presented in four primary dimensions: (1) RaR is a simple and effective prompt to improve LLM performances; (2) variations of prompts still fall in the methodology of RaR and remain robustly effective; (3) LLMs, while all benefit from RaR, have different proficiency in rephrasing and benefit at different levels.

### Benchmark Tasks

We evaluate the zero-shot capabilities of LLMs across multiple benchmark tasks in different categories. As proposed by [allenzhu2023physics], we consider the following tasks that even advanced LLMs such as GPT-4 are found to respond poorly to many of these questions.

- **Knowledge Classification** [allenzhu2023physics]. Sampling a pool of individuals with Wikipedia pages, this task challenges the LLM to decide if a renowned person was born on an even day, month, or year.

- **Knowledge Comparison** [allenzhu2023physics]. Using the same pool of individuals, this task instructs the LLM to compare the ages of two people and decide who was born earlier.

Furthermore, we consider the following widely-used datasets for a comprehensive evaluation, which are also widely considered in previous prompting works [wei2022chain].

- **CSQA** [talmor2019commonsenseqa]. The CommonSense QA data encompasses a range of questions that evaluate the ability of commonsense understanding of the world and involves intricate semantics.

- **Date Understanding** [srivastava2023beyond]. Sourced from Big-bench [srivastava2023beyond], the Date Understanding task emphasizes commonsense reasoning and deducing a date from a provided context. We consider a more difficult version where we do not provide the choices of potential answers and let the LLM answer directly.

- **Last Letter Concatenation** [Fortes_simple-dataset-generation_2023]. The task centers on symbolic reasoning, and asks the LLM to concatenate the final letters of a given list of names. We consider concatenation for two names as well as a more difficult task of concatenation for four names.

- **Coin Flip**. Sourced from Hugging Face, the task asks the LLM if the coin still heads up, given its initial condition and subsequent actions of people who either flipped or did not flip the coin. We add an additional "Flip means reverse." to the questions.

- **Sports** [srivastava2023beyond]. Sourced from Big-bench [srivastava2023beyond], the Sports Understanding task primarily asks if a sentence is plausible or implausible, where a prominent sports figure is depicted performing specific sports-related actions.

### Main Results

We conduct experiments on the aforementioned benchmark datasets using GPT-4 [openai2023gpt4]. We investigate the performance of RaR, which allows the LLM to both rephrase and respond to the question in a single query. Such an approach can be considered as a simple zero-shot strategy to improve the LLM's performance on any question. We compare the accuracy of GPT-4 with or without RaR. Across a diverse span of 10 tasks that emphasize different aspects of LLM's capabilities, RaR consistently yields distinguishable improvements for GPT-4. Notably, for tasks that GPT-4 originally finds highly challenging (e.g., last letter concatenation), RaR exhibits remarkable improvement even to almost 100% accuracy. Indeed, similar to human communication, rephrasing and elaborating a question and then answering is an effective approach. In summary of the results, RaR provides a universal, plug-and-play zero-shot prompt that allows for efficient and effective performance improvement of LLMs on general tasks.

[IMAGE: Accuracy (%) comparison of different prompts using GPT-4. RaR improves the accuracy of GPT-4 across 10 tasks. A larger margin indicates a less well-designed question. For tasks such as CSQA where the question quality is good enough, our method still offers a marginal improvement.]

### Variations of Prompt

Our primary findings were obtained using the specific prompt. However, it is important to note that variations of this prompt with modified phrases remain aligned with the RaR methodology's underlying principles. We show the performance of GPT-4 across the four variations of the RaR prompt. Despite the fact that changes in prompt wording induce minor fluctuations in GPT-4's zero-shot performance, a consistent enhancement relative to the baseline results is observed across all variations.

### Performance across Various LLMs

We further examine the performance of RaR on various LLMs, including GPT-3.5 and Vicuna [vicuna2023], a fine-tuned model from LLaMA-2, to investigate if different LLM architectures can provide consistent response improvement by rephrasing the questions. Specifically, we consider `GPT-4-0613`, `GPT-3.5-turbo-0613`, and `Vicuna-13b-v1.5`. Due to `Vicuna-13b-v1.5`'s near-zero performance on Last Letter Concatenation (4), we exclude this task from the evaluation of `Vicuna-13b-v1.5`. Remarkably, all examined LLMs demonstrate enhanced performance with RaR, resulting in a notable increase in accuracy across the majority of the tasks. More advanced models, such as GPT-4, benefit from the most significant gains across all tasks, while models of lesser complexity, like Vicuna, achieve modest improvements using our approach. On certain tasks such as Sports, GPT-3.5 and Vicuna even exhibit slightly diminished performance.

We wrap up this experiment with the following key insight: all models can benefit from rephrasing questions, with more advanced models expected to gain a larger improvement.

[IMAGE: Accuracy (%) of GPT-4-0613, GPT-3.5-turbo-0613 and Vicuna-13b when testing on original and self-rephrased questions using Two-step RaR. GPT-4 enjoys larger improvement on various tasks compared with GPT-3.5 and Vicuna.]

## Let Stronger LLMs Rephrase for Weaker LLMs to Respond

While different LLMs possess different rephrasing capabilities and benefit at different levels from RaR, we further pose the question that: can stronger LLMs be leveraged to help weaker LLMs in clarification of the prompts? To further utilize the quality improvement of the questions rephrased by larger models, like GPT-4, we introduce a variation of RaR called **Two-step RaR** that separates the rephrasing step from responding step in RaR. Intuitively, even among humans, a more detailed and precise question elicits more accurate and decisive responses.

Two-step RaR follows this intuition by designing a two-step procedure to improve the quality of the questions: in the first step, given a query `question`, we generate a self-rephrased query `rephrased_question` by prompting a **rephrasing LLM** with the following prompt:

```
"{question}"
Given the above question, rephrase and expand it to help you do
better answering. Maintain all information in the original question.
```

Then the original question and the rephrased question are combined to prompt a **responding LLM** with the following prompt:

```
(original) {question}
(rephrased) {rephrased_question}
Use your answer for the rephrased question to answer the original question.
```

Notably, the rephrasing LLM and the responding LLM can be either the same or different models. As we shown in experiments, different LLMs exhibit distinct proficiency in question rephrasing. Here, we examine if the rephrased questions generated by a stronger LLM (GPT-4) can benefit a weaker LLM (Vicuna). Consistent with our expectation that GPT-4 can better align with human intention and clarify the question, we observe that its rephrased questions remarkably enhance `Vicuna-13b-v1.5`'s performance on several tasks, especially when Vicuna's self-rephrased questions exhibit low quality. Indeed, the questions can be clarified further for Vicuna, but more exploration needs to be made on its capability of self-rephrased questions.

## Discussion with Chain-of-Thought

### Discussion with Zero-shot CoT

It is widely known that zero-shot CoT, by appending the instruction "Let's think step by step." to queries, can effectively improve the performance of LLMs on reasoning tasks. However, we highlight some examples where zero-shot CoT fails to deliver improvements, sometimes even leading to diminished performance. In contrast, RaR consistently demonstrates effectiveness. Lastly, we note that our method is complementary to zero-shot CoT and can be combined together by simply adding "let's think step by step" to the prompt.

**Tasks.** We examine the **Chinese Idiom** task as introduced in [allenzhu2023physics], specifically the most difficult task of inferring the first letter. This task involves taking widely recognized four-character Chinese idioms and masking one character at one position to let LLM correctly infer the masked character. Furthermore, we also use the **StereoSet** task [nadeem2021stereoset], which assesses the stereotypical biases present in LLMs with respect to gender, race, profession, and religion. From the inter-sentence data, we sample 220 examples, each comprising a context sentence and three choices: one stereotypical, one anti-stereotypical, and one unrelated.

**Results.** Even though RaR enhances LLM's performance, accurately inferring the first character of the Chinese Idiom task remains a challenge. One might then ask: does zero-shot CoT provide consistent improvement to LLM in such tasks as it does on other reasoning tasks? Our discovery is, in fact, zero-shot CoT may result in worse performances (31.43%) for such hard tasks, as the LLM tends to hallucinate during the intermediate steps -- a phenomenon similar to hallucination snowballing [zhang2023language]. Furthermore, as [shaikh2022second] discovered on other language models, zero-shot CoT may result in undesired reasoning towards bias and toxicity. We demonstrate the performance of GPT-4 on StereoSet. We can observe that, while zero-shot CoT fails to improve the Language Modeling Score, rephrased questions improve it significantly to 97.73%. This implies that, with RaR, the LLM rarely opts for unrelated choices. Moreover, while zero-shot CoT improves the percentage of fair responses (choosing neither of them), RaR achieves the best performance.

### Improvement on Few-Shot CoT

Few-shot CoT [wei2022chain], while different from the zero-shot setting that we consider, has been the most effective CoT technique for its usage of few-shot examples. Instead of aligning the question to what the LLM best receives, few-shot CoT guides the LLM to reason using the supplied human logic. Nonetheless, a concern emerges: How do LLMs respond when the human-crafted examples are flawed or contain errors? As corroborated by a recent parallel study [pawelczyk2023incontext], we similarly observe that LLMs can be adversely influenced by bad few-shot examples.

**Tasks.** We revisit the **Last Letter Concatenation** task and refer to the few-shot examples provided in [wei2022chain]. The examples follow a specific logic: obtain the last letter of the first and second word, and concatenate these letters, resulting in the answer. Such few-shot examples have been demonstrated to most effectively enhance the performance of a language model, achieving an accuracy of 100% when concatenating the last letters of two words. Conversely, we explore an example that employs the following logic: obtain the **first** letter of the first and second word, and concatenate these letters, providing the answer for **last** letter concatenation. Our aim is to investigate how this alternative few-shot prompt, despite bearing a logic similar to the original prompt and the correct answer, influences the performance of the GPT-4.

**Results.** GPT-4 tends to stick to the logic of our modified prompt, resulting in an incorrect answer. It accurately concatenates all first letters, but concludes with a seemingly arbitrary final answer. The performance of the one-shot CoT evidently degraded with just one flawed example. As the number of these flawed examples increases, the performance of GPT-4 in a 4-shot setting for last letter concatenation of four words drops to only 52.27%. This observation reveals a potential pitfall in employing few-shot CoT: given that these examples are user-crafted, their quality becomes vital. Meanwhile, we discovered that RaR enables GPT-4 to correct any pitfalls in the logic of the given examples.

[IMAGE: Few-shot CoT can effectively instruct the LLM to reason in a similar manner to the provided examples. A badly crafted QA example results in the LLM following the provided logic but reaching an arbitrary answer.]

## Conclusion

In this paper, we have investigated the existing misunderstandings that occur between humans and LLMs and demonstrated that questions that appear clear to humans may still be misinterpreted by LLMs. Building on this insight, we introduced Rephrase and Respond (RaR), a novel approach that prompts an LLM to first rephrase and clarify the question before answering it. Our empirical evaluations, conducted across a range of benchmark datasets, confirm the effectiveness of our proposed methods. Further analysis reveals that while all models gain enhanced performance through question rephrasing, the more sophisticated models exhibit more substantial improvements. Based on the observation, We presented Two-step RaR, a variation of RaR that employs a rephrasing LLM to refine questions for subsequent use by any responding LLM. Crucially, we have found that the enhancement in question quality achieved through rephrasing is transferable across models. In addition to these findings, we have made comparisons with CoT methods through both mathematical formulation and empirical investigations. We also demonstrated that RaR is complementary to CoT, and can be leveraged to achieve additional performance gains.

## Appendix: Experiment Details

We use the entire dataset for **Dates Understanding**, and randomly draw subsets of size 220 for the rest tasks. We use accuracy to evaluate the performance of the LLM. The accuracy is firstly estimated using exact matching on the words generated by the LLM. Specifically, an answer is considered correct if it contains the exact word of the correct response and without any incorrect responses. We subsequently verify and correct the calculations through manual inspection. For certain tasks, to constrain the response format (e.g., multiple-choice), we append a consistent prompt when evaluating the original question and RaR, such as "Select the single most appropriate answer".

Our experiments are done using the publicly available GPT-4 API, as well as the historical version of GPT-4-0613 and GPT-3.5-turbo-0613. We are also considering an open-source LLM model, Vicuna-13B-v1.5.

**Evaluation.** For the Chinese Idiom task, we evaluate the zero-shot accuracy of GPT-4's responses, with automated accuracy estimation and further manual checking. For StereoSet, as suggested by [nadeem2021stereoset], two crucial evaluation metrics should be considered: the **Language Modeling Score**, which assesses whether the LLM selects related options over unrelated ones, and the **Stereotype Score**, which quantifies the percentage of data that a model favors stereotypical choices over anti-stereotypical ones. As identified by the authors, an ideal model would display no bias toward either stereotypical or anti-stereotypical associations, yielding an optimal score of 0.5 for the Stereotype Score. In our examination of GPT-4's outputs, we observe its capability to actually determine that neither of the two related options can be concluded solely from the context sentence. Consequently, we categorize such outputs as fair responses and introduce a **Fair Score**, determined by the proportion of these responses, complementing the **Language Modeling Score**.

## Appendix: Additional Experiment Results

[IMAGE: Accuracy (%) of GPT-4-0613, GPT-3.5-turbo-0613 and Vicuna-13b when testing on original and self-rephrased questions using Two-step RaR. GPT-4 enjoys larger improvement on various tasks compared with GPT-3.5 and Vicuna.]

### Rephrasings from Different LLMs

Initial observations suggest that `Vicuna-13b-v1.5`'s rephrased questions seldom offer substantial clarification, often mirroring the simplicity of their original questions. In some cases, `Vicuna-13b-v1.5` perturbs the question's intent by changing "yesterday" to "today". While both GPT-3.5 and GPT-4 can elucidate questions, GPT-3.5 occasionally introduces extra details or misinterpretations. For example, GPT-3.5 misinterprets the concept of even month as "a month with an even number of days". Similarly, GPT-3.5 introduces a wrong constraint of "recent" game. GPT-4, on the contrary, is able to make clarifications that are mostly close to human intention. We also observe that GPT-3.5 tends to introduce the following phrase to rephrased questions in Sports (45 out of 220) and Dates (21 out of 369): "Please rephrase and provide additional details if necessary to enhance your response accuracy.", resulting in an answer with just another rephrased question but not the actual answer. Therefore, we remove all sentences containing "rephrase" for GPT-3.5 on these two datasets.

### Multiple Rephrasings: Will the Questions Converge?

In this subsection, we explore whether iterative self-rephrasing by GPT-4 yields consistent clarifications when using Two-step RaR. Specifically, we utilize the Two-step RaR prompt to enable GPT-4 to rephrase a question, then feed its output back into the same prompt for a second and third round of rephrasing. We consider "Was Abraham Lincoln born on an even day?" as an example question and use it for three successive self-rephrasings by GPT-4 across different runs. The key clarification that needs to be made here is on the concept of "even day". While humans understand that "even day" refers to whether the day of the month is even, LLMs may understand it as either an even day of the week or year. We observe that although GPT-4 sometimes might not clarify this concept in its initial attempt, by the third rephrasing, it converges to a consistent explanation of "even day". Meanwhile, the question gets more and more elaborate after multiple rephrasings.

## Appendix: Input/Output Examples

This section provides specific input and output examples of GPT-4 on each of task we considered, using either original questions or RaR.

### Knowledge Classification (Even Day) - Original Questions

| Question | GPT-4 Response |
|----------|----------------|
| Was Barack Obama born in an even day? | [Incorrect] No, Barack Obama was born on August 4, 1961, which is an even date but an odd day. |
| Was Kanye West born in an even day? | [Incorrect] No, Kanye West was born on June 8, 1977, which is an even day. |
| Was Stephen Hawking born in an even day? | [Incorrect] No, Stephen Hawking was born on January 8, 1942. Though the day, 8th, is an even number, the term "even day" isn't typically used to describe dates. |
| Was Frida Kahlo born in an even day? | [Incorrect] No, Frida Kahlo was born on July 6, 1907. Therefore, she was born on an odd day. |
| Was Leonardo da Vinci born in an even day? | [Correct] No, Leonardo da Vinci was born on April 15, 1452, which is an odd day. |
| Was Ludwig van Beethoven born in an even day? | [Correct] No, Ludwig van Beethoven was born on December 17, 1770, which is an odd day. |

### Knowledge Classification (Even Day) - With RaR

| Question | GPT-4 Response |
|----------|----------------|
| "Was Barack Obama born in an even day?" Rephrase and expand the question, and respond. | [Correct] "Did the former United States President, Barack Obama, have his birthday fall on an even numbered day of a month?" Barack Obama was born on August 4, 1961. So yes, he was born on an even numbered day. |
| "Was Kanye West born in an even day?" Rephrase and expand the question, and respond. | [Correct] The question asks, "Was the day of Kanye West's birth an even-numbered day?" Kanye West was born on June 8, 1977. Thus, yes, he was born on an even day, the 8th of June. |
| "Was Stephen Hawking born in an even day?" Rephrase and expand the question, and respond. | [Correct] The expanded version of the question could be phrased as, "Was renowned physicist and author Stephen Hawking born on a date that is classified as an even day?". Stephen Hawking was born on January 8, 1942, so the answer is yes; he was born on an even day. |
| "Was Frida Kahlo born in an even day?" Rephrase and expand the question, and respond. | [Correct] "Did the famous Mexican artist Frida Kahlo have her birth date fall on an even numbered day of the month?" Yes, she was. Frida Kahlo was born on July 6th, 1907, which is an even day of the month. |

### Coin Flip - Original Questions

| Question | GPT-4 Response |
|----------|----------------|
| A coin is heads up. aluino flips the coin. arthor flips the coin. Is the coin still heads up? Flip means reverse. Answer the Yes or No question. | [Incorrect] No |
| A coin is heads up. jumaimah flips the coin. buity flips the coin. Is the coin still heads up? Flip means reverse. Answer the Yes or No question. | [Incorrect] No |
| A coin is heads up. kinta does not flip the coin. renit does not flip the coin. Is the coin still heads up? Flip means reverse. Answer the Yes or No question. | [Correct] Yes |
| A coin is heads up. brandarius does not flip the coin. gitta flips the coin. Is the coin still heads up? Flip means reverse. Answer the Yes or No question. | [Correct] No |

### Coin Flip - With RaR

| Question | GPT-4 Response |
|----------|----------------|
| "A coin is heads up. aluino flips the coin. arthor flips the coin. Is the coin still heads up? Flip means reverse." Rephrase and expand the question, and respond. Answer the Yes or No question. | [Correct] The coin started out being heads up. Then, Aluino flipped the coin, reversing its side. After that, Arthor also flipped the coin, reversing its side again. Is the coin facing heads up now? Considering the action of flipping the coin means to reverse its side, after two flips, the coin would indeed be back in its original position. So, yes, the coin is still heads up. |
| "A coin is heads up. jumaimah flips the coin. buity flips the coin. Is the coin still heads up? Flip means reverse." Rephrase and expand the question, and respond. Answer the Yes or No question. | [Correct] The coin is initially facing heads up. Then, it is flipped once by Jumaimah and again by Buity. After these two flips, is the coin still facing heads up? Taking into consideration that flipping the coin means to turn it over to its opposite side, the answer is Yes, the coin is still heads up after two flips. |

### Last Letter Concatenation - Original Questions

| Question | GPT-4 Response |
|----------|----------------|
| Take the last letters of the words in "Beth Joel" and concatenate them. | [Incorrect] "hel" |
| Take the last letters of the words in "Patrick Lorena" and concatenate them. | [Incorrect] kkna |
| Take the last letters of the words in "Edgar Bob" and concatenate them. | [Correct] "rb" |
| Take the last letters of the words in "Alexandra Betty" and concatenate them. | [Incorrect] ara |
| Take the last letters of the words in "Paul Liz" and concatenate them. | [Incorrect] uliz |
| Take the last letters of the words in "Sheila Alberto" and concatenate them. | [Correct] "ao" |

### Last Letter Concatenation - With RaR

| Question | GPT-4 Response |
|----------|----------------|
| "Take the last letters of the words in 'Beth Joel' and concatenate them." Rephrase and expand the question, and respond. | [Correct] Can you merge the last letters from each of the words in the name "Beth Joel" together? What would the resultant combination look like? The last letters from the words "Beth" and "Joel" are "h" and "l" respectively. When we merge them together, the resultant combination is "hl". |
| "Take the last letters of the words in 'Patrick Lorena' and concatenate them." Rephrase and expand the question, and respond. | [Correct] Could you please look at each word in the term "Patrick Lorena," find the last letter of each word, and then join these letters together? Response: The last letters of "Patrick" and "Lorena" are "k" and "a", respectively. When we concatenate them, we get "ka". |

### Sports Understanding - Original Questions

| Question | GPT-4 Response |
|----------|----------------|
| Is the following sentence plausible? "Javier Zanetti earned a direct kick" Answer the Yes or No question. | [Incorrect] No |
| Is the following sentence plausible? "Jayson Tatum nutmegged the defender" Answer the Yes or No question. | [Incorrect] Yes |
| Is the following sentence plausible? "Sean Couturier passed the puck in the Stanley Cup" Answer the Yes or No question. | [Correct] Yes |
| Is the following sentence plausible? "Tuukka Rask hit a double" Answer the Yes or No question. | [Correct] No |
| Is the following sentence plausible? "Sam Darnold struck out" Answer the Yes or No question. | [Incorrect] Yes |

### Sports Understanding - With RaR

| Question | GPT-4 Response |
|----------|----------------|
| 'Is the following sentence plausible? "Javier Zanetti earned a direct kick"' Rephrase and expand the question, and respond. Answer the Yes or No question. | [Correct] "Is it plausible or possible that Javier Zanetti received a direct free kick during a soccer game?" Yes, it is plausible. |
| 'Is the following sentence plausible? "Tuukka Rask hit a double"' Rephrase and expand the question, and respond. Answer the Yes or No question. | [Correct] Is it possible that Tuukka Rask, a professional ice hockey player, could have hit a double in a game? No, Tuukka Rask is a professional ice hockey goaltender for the Boston Bruins. He would not be involved in a sport where he would hit a double, such as baseball. The phrase "hitting a double" isn't applicable to ice hockey, making the sentence implausible. |
| 'Is the following sentence plausible? "Sam Darnold struck out"' Rephrase and expand the question, and respond. Answer the Yes or No question. | [Correct] Is it reasonable or believable to say "Sam Darnold struck out"? No, it's not plausible because Sam Darnold is a known professional football player, and the term "struck out" is used in baseball, not football. |
